/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.block;

import com.min01.archaeology.blockentity.DecoratedPotBlockEntity;
import com.min01.archaeology.init.ArchaeologyItemTags;
import com.min01.archaeology.init.ArchaeologySounds;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DecoratedPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final ResourceLocation SHERDS_DYNAMIC_DROP_ID = new ResourceLocation("sherds");
    private static final VoxelShape BOUNDING_BOX = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    private static final BooleanProperty CRACKED = BooleanProperty.m_61465_((String)"cracked");
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DecoratedPotBlock(BlockBehaviour.Properties p_273064_) {
        super(p_273064_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CRACKED, (Comparable)Boolean.valueOf(false)));
    }

    public PushReaction m_5537_(BlockState p_60584_) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState p_276307_, Direction p_276322_, BlockState p_276280_, LevelAccessor p_276320_, BlockPos p_276270_, BlockPos p_276312_) {
        if (((Boolean)p_276307_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_276320_.m_186469_(p_276270_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_276320_));
        }
        return super.m_7417_(p_276307_, p_276322_, p_276280_, p_276320_, p_276270_, p_276312_);
    }

    public BlockState m_5573_(BlockPlaceContext p_272711_) {
        FluidState fluidstate = p_272711_.m_43725_().m_6425_(p_272711_.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)p_272711_.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)CRACKED, (Comparable)Boolean.valueOf(false));
    }

    public boolean m_7357_(BlockState p_276295_, BlockGetter p_276308_, BlockPos p_276313_, PathComputationType p_276303_) {
        return false;
    }

    public VoxelShape m_5940_(BlockState p_273112_, BlockGetter p_273055_, BlockPos p_273137_, CollisionContext p_273151_) {
        return BOUNDING_BOX;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_273169_) {
        p_273169_.m_61104_(new Property[]{HORIZONTAL_FACING, WATERLOGGED, CRACKED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_273396_, BlockState p_272674_) {
        return new DecoratedPotBlockEntity(p_273396_, p_272674_);
    }

    public List<ItemStack> m_7381_(BlockState p_287683_, LootContext.Builder p_287582_) {
        BlockEntity blockentity = (BlockEntity)p_287582_.m_78982_(LootContextParams.f_81462_);
        if (blockentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)blockentity;
            p_287582_.m_78979_(SHERDS_DYNAMIC_DROP_ID, (p_284876_, p_284877_) -> decoratedpotblockentity.getDecorations().sorted().map(Item::m_7968_).forEach(p_284877_));
        }
        return super.m_7381_(p_287683_, p_287582_);
    }

    public void m_5707_(Level p_273590_, BlockPos p_273343_, BlockState p_272869_, Player p_273002_) {
        ItemStack itemstack = p_273002_.m_21205_();
        BlockState blockstate = p_272869_;
        if (itemstack.m_204117_(ArchaeologyItemTags.BREAKS_DECORATED_POTS) && itemstack.getEnchantmentLevel(Enchantments.f_44985_) <= 0) {
            blockstate = (BlockState)p_272869_.m_61124_((Property)CRACKED, (Comparable)Boolean.valueOf(true));
            p_273590_.m_7731_(p_273343_, blockstate, 4);
        }
        super.m_5707_(p_273590_, p_273343_, blockstate, p_273002_);
    }

    public FluidState m_5888_(BlockState p_272593_) {
        return (Boolean)p_272593_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_272593_);
    }

    public SoundType m_49962_(BlockState p_277561_) {
        return (Boolean)p_277561_.m_61143_((Property)CRACKED) != false ? ArchaeologySounds.DECORATED_POT_CRACKED : ArchaeologySounds.DECORATED_POT;
    }

    public void m_5871_(ItemStack p_285238_, @Nullable BlockGetter p_285450_, List<Component> p_285448_, TooltipFlag p_284997_) {
        super.m_5871_(p_285238_, p_285450_, p_285448_, p_284997_);
        DecoratedPotBlockEntity.Decorations decoratedpotblockentity$decorations = DecoratedPotBlockEntity.Decorations.load(BlockItem.m_186336_((ItemStack)p_285238_));
        if (!decoratedpotblockentity$decorations.equals(DecoratedPotBlockEntity.Decorations.EMPTY)) {
            p_285448_.add(CommonComponents.f_237098_);
            Stream.of(decoratedpotblockentity$decorations.front(), decoratedpotblockentity$decorations.left(), decoratedpotblockentity$decorations.right(), decoratedpotblockentity$decorations.back()).forEach(p_284873_ -> p_285448_.add((Component)new ItemStack((ItemLike)p_284873_, 1).m_41786_().m_6879_().m_130940_(ChatFormatting.GRAY)));
        }
    }
}

